
local kabvars "post_ln_GDPc_00 post_educ_workpop_00 post_ln_pop_00 post_ln_popdens_00 post_HHI_relig_sd post_city post_HHI_elec_sd post_golkar_win"
foreach a of local kabvars {
gen `a'_orig=`a'
}

*** columns 1-9
** first, demeaning etc.

* for city and golkar_win: here we have data for all districts, and we don't need to exclude districts that democratize in 1999, since city and golkar_win are determined before 2000 (unlike e.g. GDP per capita 2000)
foreach y of global outcomes_empl {
foreach z of global all {
foreach e of global educvar {
    
quietly reghdfe `y' post_firstdem post_`e' elecyear if `z'==1 & year>1999 & year<2005 & post_in_2000==0 ///
& neversplit_9804==1 & notransgov==1 & intermed_bup!=1 & diff_prepost_ns5y==1 & firstdem_premgo_bef05==0 & seconddem_inpower_04==0, absorb(id indyear provyear97) cluster(kabID97)
gen insample_full= e(sample)==1
replace insample_full=. if insample_full==0
local fullsamplevars "city golkar_win"
foreach x of local fullsamplevars {
egen `x'_mean = mean(`x' * insample_full)
gen `x'_dmn = `x' - `x'_mean
replace `x'_dmn= . if insample_full==.
}
}
}
}

* now for HHI_elec, which we do separately because don't have data on two districts
foreach y of global outcomes_empl {
foreach z of global all {
foreach e of global educvar {
    
quietly reghdfe `y' post_firstdem post_`e' elecyear HHI_elec if `z'==1 & year>1999 & year<2005 & post_in_2000==0 ///
& neversplit_9804==1 & notransgov==1 & intermed_bup!=1 & diff_prepost_ns5y==1 & firstdem_premgo_bef05==0 & seconddem_inpower_04==0, absorb(id indyear provyear97) cluster(kabID97)
gen insample_HHIelec= e(sample)==1
replace insample_HHIelec=. if insample_HHIelec==0
local sampleHHI "HHI_elec_sd"
foreach x of local sampleHHI {
egen `x'_mean = mean(`x' * insample_HHIelec)
gen `x'_dmn = `x' - `x'_mean
replace `x'_dmn = . if insample_HHIelec==.
}
}
}
}

* now for the regressions in which we exclude districts with mayor election in 1999 (regressions including GDP per capita 2000, etc.)
foreach y of global outcomes_empl {
foreach z of global all {
foreach e of global educvar {
    
quietly reghdfe `y' post_firstdem post_`e' elecyear if `z'==1 & year>1999 & year<2005 & post_in_2000==0 ///
& neversplit_9804==1 & notransgov==1 & intermed_bup!=1 & diff_prepost_ns5y==1 & firstdem_premgo_bef05==0 & seconddem_inpower_04==0 & elecyear_firstdem>1999 & insample_HHIelec==1 ///
, absorb(id indyear provyear97) cluster(kabID97)
gen insample_no99= e(sample)==1
replace insample_no99=. if insample_no99==0
local no99samplevars "ln_GDPc_00 ln_pop_00 educ_workpop_00 ln_popdens_00 HHI_relig_sd"
foreach x of local no99samplevars {
egen `x'_mean = mean(`x' * insample_no99)
gen `x'_dmn = `x' - `x'_mean
replace `x'_dmn = . if insample_no99==.
}
}
}
}

ds *dmn
local demean=r(varlist)
foreach x of local demean {
gen post_`x' = post_firstdem * `x'
}


* now run the actual regressions of columns 1-9
foreach e of global educvar {
local post1_educ "post_firstdem elecyear post_`e'"
local post1_gk "post_firstdem elecyear post_`e' post_golkar_win"
local post1_gk_k "post_firstdem elecyear post_`e' post_golkar_win post_city"
local post1_gk_k_H "post_firstdem elecyear post_`e' post_golkar_win post_city post_HHI_elec_sd"
local post1_gk_k_H_g "post_firstdem elecyear post_`e' post_golkar_win post_city post_HHI_elec_sd post_ln_GDPc_00"
local post1_gk_k_H_g_e "post_firstdem elecyear post_`e' post_golkar_win post_city post_HHI_elec_sd post_ln_GDPc_00 post_educ_workpop_00"
local post1_gk_k_H_g_e_p "post_firstdem elecyear post_`e' post_golkar_win post_city post_HHI_elec_sd post_ln_GDPc_00 post_educ_workpop_00 post_ln_pop_00"
local post1_gk_k_H_g_e_p_pd "post_firstdem elecyear post_`e' post_golkar_win post_city post_HHI_elec_sd post_ln_GDPc_00 post_educ_workpop_00 post_ln_pop_00 post_ln_popdens_00"
local post1_gk_k_H_g_e_p_pd_r "post_firstdem elecyear post_`e' post_golkar_win post_city post_HHI_elec_sd post_ln_GDPc_00 post_educ_workpop_00 post_ln_pop_00 post_ln_popdens_00 post_HHI_relig_sd"

local kab_cum ""`post1_educ'" "`post1_gk'" "`post1_gk_k'" "`post1_gk_k_H'" "`post1_gk_k_H_g'" "`post1_gk_k_H_g_e'" "`post1_gk_k_H_g_e_p'" "`post1_gk_k_H_g_e_p_pd'" "`post1_gk_k_H_g_e_p_pd_r'""

local kabvars "post_ln_GDPc_00 post_educ_workpop_00 post_ln_pop_00 post_ln_popdens_00 post_HHI_relig_sd post_city post_HHI_elec_sd post_golkar_win"
foreach a of local kabvars {
replace `a'=`a'_dmn
}

foreach y of global outcomes_empl {
local k=1
foreach z of global all {
foreach x of local kab_cum {
foreach e of global educvar {

reghdfe `y' `x' if `z'==1 & year>1999 & year<2005 & post_in_2000==0 ///
& neversplit_9804==1 & notransgov==1 & diff_prepost_ns5y==1 & intermed_bup!=1 & firstdem_premgo_bef05==0 & seconddem_inpower_04==0 ///
, absorb(id indyear provyear97) cluster(kabID97)
esti store OA15`y'_`k'

capture noisily lincomest post_firstdem
esti store OA15m_p_`k'
esti restore OA15`y'_`k'
capture noisily lincomest post_firstdem + post_`e'
esti store OA15m_pc_`k'
esti restore OA15`y'_`k'

local ++k
}
}
}
}
}



*** column 10
foreach a of local kabvars {
replace `a' = `a'_orig
}
drop *dmn* *orig insample* mean_*

* first, demeaning etc.
foreach y of global outcomes_empl {
local k=10
foreach z of global all {
foreach x of global allcvars {
foreach e of global educvar {

quietly reghdfe `y' `x' if `z'==1 & year>1999 & year<2005 & post_in_2000==0 & neversplit_9804==1 & notransgov==1 & diff_prepost_ns5y==1 & intermed_bup!=1 & firstdem_premgo_bef05==0 & seconddem_inpower_04==0 & elecyear_firstdem>1999 ///
, absorb(id indyear provyear97) cluster(kabID97)
gen insample_AC=e(sample)==1
replace insample_AC=. if insample_AC==0
}
}
}
}

local vars "female_firstdem college_lastsoe age_elec_firstdem native_firstdem private_firstdem golkar_win city HHI_elec_sd ln_GDPc_00 educ_workpop_00 ln_pop_00 ln_popdens_00 HHI_relig_sd"
foreach x of local vars {
egen mean_`x' = mean(`x'*insample_AC)
gen `x'_dmn = `x' - mean_`x'
}


ds *_dmn
local demean=r(varlist)
foreach x of local demean {
gen post_`x' = post_firstdem * `x'
}


* now run the actual regression of column 10
foreach y of global outcomes_empl {
local k=10
foreach z of global all {
foreach x of global allcvars {
foreach e of global educvar {

foreach a of local vars {
replace post_`a'=post_`a'_dmn
}

reghdfe `y' `x' if `z'==1 & year>1999 & year<2005 & post_in_2000==0 & neversplit_9804==1 & notransgov==1 & diff_prepost_ns5y==1 & intermed_bup!=1 & firstdem_premgo_bef05==0 & seconddem_inpower_04==0 & elecyear_firstdem>1999 ///
, absorb(id indyear provyear97) cluster(kabID97)
esti store OA15ln_empl_10
capture noisily lincomest post_firstdem /* first democratic mayor has no college degree */
esti store OA15m_p_`k'
esti restore OA15`y'_`k'
capture noisily lincomest post_firstdem + post_`e' /* first democratic mayor has college degree */
esti store OA15m_pc_`k'
esti restore OA15`y'_`k'

local ++k
}
}
}
}

