
duplicates drop kabID97, force

* whenever no 2000-measured variable (such as GDP) is included in the regression (this applies to column 2), we want to include districts that elect the first democratic mayor in 1999.
* in the other regressions (some regressions in column 1, and the regressions in columns 3 and 4) we exclude those districts, to avoid potential reverse causality. see also the table notes of Table OA12.
* the simplest way of doing this, in terms of coding, is: replace the 00-RHS variables with missing, for districts with election in 1999. 
local vars00 "ln_GDPc_00 educ_workpop_00 ln_pop_00 ln_popdens_00 HHI_relig_sd"
foreach x of local vars00 {
replace `x'=. if elecyear_firstdem==1999
}

* we also want to run the regressions that include mayor characteristics on the RHS based on the sample of districts for which the last Suharto mayor is NOT the first democratic mayor, since 
* otherwise we introduce a mechanical correlation between college_firstdem and college_lastsoe.
* the simplest way of doing this, in terms of coding, is: replace college_lastsoe with missing for districts that elect the last Soeharto mayor as first democratic mayor.
replace college_lastsoe=. if lastsoe_is_firstdem==1

* column 1
local depvars "college_firstdem"
local reg_educ_RHS "female_firstdem age_elec_firstdem native_firstdem private_firstdem college_lastsoe golkar_firstdem golkar_win HHI_elec_sd ln_GDPc_00 educ_workpop_00 ln_pop_00 ln_popdens_00 city HHI_relig_sd"
local k=1
foreach y of local depvars {
foreach x of local reg_educ_RHS {
reghdfe `y' `x' if neversplit_9804==1 & notransgov==1 & diff_prepost_ns5y==1 & intermed_bup!=1 & firstdem_premgo_bef05==0 & nomanuf==0 & tag_kabID97_year==1, vce(robust) absorb(provID97)
esti store educ_RHS_sg_`k'
local k = `k' + 1 
}
}

* now run a dofile that allows to stack the regression coeffs of the different regressions just run in one column; see dofile for source.
cd "C:\Users\s14750\Google Drive\Docs\Election Project\dofiles\"
do "dofiles\regs_Table_OA12_create program to stack coefficients in one column.do"
eststo educ_RHS_sg_all: appendmodels educ_RHS_sg_1 educ_RHS_sg_2 educ_RHS_sg_3 educ_RHS_sg_4 educ_RHS_sg_5 educ_RHS_sg_6 educ_RHS_sg_7 educ_RHS_sg_8 educ_RHS_sg_9 educ_RHS_sg_10 educ_RHS_sg_11 educ_RHS_sg_12 educ_RHS_sg_13 educ_RHS_sg_14


* columns 2-4
local reg1_educ_RHS "female_firstdem age_elec_firstdem native_firstdem private_firstdem college_lastsoe"
local reg2_educ_RHS "city ln_GDPc_00 educ_workpop_00 ln_pop_00 ln_popdens_00 golkar_win HHI_elec_sd HHI_relig_sd"
local reg3_educ_RHS "female_firstdem age_elec_firstdem native_firstdem private_firstdem college_lastsoe city ln_GDPc_00 educ_workpop_00 ln_pop_00 ln_popdens_00 golkar_win HHI_elec_sd HHI_relig_sd"
local reg_educ_RHS_allspec ""`reg1_educ_RHS'" "`reg2_educ_RHS'" "`reg3_educ_RHS'""

foreach y of local depvars {
foreach x of local reg_educ_RHS_allspec {
reghdfe `y' `x' if neversplit_9804==1 & notransgov==1 & diff_prepost_ns5y==1 & intermed_bup!=1 & firstdem_premgo_bef05==0 & nomanuf==0 & tag_kabID97_year==1, vce(robust) absorb(provID97)
}
}

